/////////////////////////////////////////////////////////////////////////////
// Logox4 SDK - DLL Wrapper for cpp, compatible to mfc runtime libraries
// (C) Copyright G DATA Software AG 1992-2002
//
//	(4.0.0.0)	03/08/01	creation
//				30/08/01	LogoxRelease fixed
//	(4.0.0.1)	10/01/01	broadcast
//				27/11/01	added LogoxSkip
//  (4.0.0.2)   18/02/02    added LogoxCode

#include "stdafx.h"
#include <tchar.h>

/////////////////////////////////////////////////////////////////////////////
// defines
#define LOGOX_REG_LOGOX			_T("SOFTWARE\\G DATA\\Logox")
#define LOGOX_REG_SERVERFILE	_T("ServerFile")

extern "C"
{

/////////////////////////////////////////////////////////////////////////////
// globals
static HINSTANCE g_hDLL_Logox = NULL;

/////////////////////////////////////////////////////////////////////////////
// find and load the dll
BOOL LogoxLocateDLL()
{
	DWORD dw,cbData;
	BOOL bFile=FALSE;
	HKEY hKey;
	TCHAR szPath[MAX_PATH]=_T("");

	if(g_hDLL_Logox) return TRUE;

	if (RegOpenKeyEx(HKEY_CURRENT_USER,LOGOX_REG_LOGOX,0,KEY_READ,&hKey)==ERROR_SUCCESS)
	{
		cbData = sizeof(szPath);
		bFile = RegQueryValueEx(hKey,LOGOX_REG_SERVERFILE,0,&dw,(unsigned char*)szPath,&cbData)==ERROR_SUCCESS;
		RegCloseKey(hKey);
	}
	if (!bFile && RegOpenKeyEx(HKEY_LOCAL_MACHINE,LOGOX_REG_LOGOX,0,KEY_READ,&hKey)==ERROR_SUCCESS)
	{
		cbData = sizeof(szPath);
		bFile = RegQueryValueEx(hKey,LOGOX_REG_SERVERFILE,0,&dw,(unsigned char*)szPath,&cbData)==ERROR_SUCCESS;
		RegCloseKey(hKey);
	}

	if (*szPath)
	{
		TCHAR* p;
		for(p=szPath+lstrlen(szPath)-1; p>szPath && *p!=_T('.'); p--);
		lstrcpy(p,_T(".dll"));

		g_hDLL_Logox=LoadLibrary(szPath);
		if(g_hDLL_Logox)
		{
			return TRUE;
		}
	}

	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxDLLVersion()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxDLLVersion");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxServerVersion()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxServerVersion");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxLicenseA(PCSTR szLicense)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(PCSTR);
		pf = (BOOL(WINAPI *)(PCSTR))GetProcAddress(g_hDLL_Logox,"LogoxLicenseA");
		if (pf) return pf(szLicense);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxLicenseW(PCWSTR szLicense)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(PCWSTR);
		pf = (BOOL(WINAPI *)(PCWSTR))GetProcAddress(g_hDLL_Logox,"LogoxLicenseW");
		if (pf) return pf(szLicense);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxInitialize()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxInitialize");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxIsConnected()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxIsConnected");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
void WINAPI LogoxRelease()
{
	if(LogoxLocateDLL())
	{
		void (WINAPI *pf)();
		pf = (void(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxRelease");
		if (pf) pf();
	}
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSpeakA(PCSTR szText,UINT nActionID)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(PCSTR,UINT);
		pf = (BOOL(WINAPI *)(PCSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxSpeakA");
		if (pf) return pf(szText,nActionID);
	}

	return FALSE;
}
				 
/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSpeakW(PCWSTR szText,UINT nActionID)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(PCWSTR,UINT);
		pf = (BOOL(WINAPI *)(PCWSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxSpeakW");
		if (pf) return pf(szText,nActionID);
	}

	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxPause()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxPause");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxResume()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxResume");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxStop()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxStop");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSkip()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxSkip");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxRecordA(PCSTR szFile,PCSTR szText,UINT nActionID)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(PCSTR,PCSTR,UINT);
		pf = (BOOL(WINAPI *)(PCSTR,PCSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxRecordA");
		if (pf) return pf(szFile,szText,nActionID);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxRecordW(PCWSTR szFile,PCWSTR szText,UINT nActionID)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(PCWSTR,PCWSTR,UINT);
		pf = (BOOL(WINAPI *)(PCWSTR,PCWSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxRecordW");
		if (pf) return pf(szFile,szText,nActionID);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxIsBusy()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxIsBusy");
		if (pf) return pf();
	}
	return FALSE;
}


/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxIsPaused()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxIsPaused");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetNumberOfFonts()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetNumberOfFonts");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxFindFontAliasA(PCSTR szAlias)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(PCSTR);
		pf = (UINT(WINAPI *)(PCSTR))GetProcAddress(g_hDLL_Logox,"LogoxFindFontAliasA");
		if (pf) return pf(szAlias);
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxFindFontAliasW(PCWSTR szAlias)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(PCWSTR);
		pf = (UINT(WINAPI *)(PCWSTR))GetProcAddress(g_hDLL_Logox,"LogoxFindFontAliasW");
		if (pf) return pf(szAlias);
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontNameA(UINT nIndex,PSTR szName,UINT nBytes)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT,PSTR,UINT);
		pf = (UINT(WINAPI *)(UINT,PSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontNameA");
		if (pf) return pf(nIndex,szName,nBytes);
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontNameW(UINT nIndex,PWSTR szName,UINT nBytes)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT,PWSTR,UINT);
		pf = (UINT(WINAPI *)(UINT,PWSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontNameW");
		if (pf) return pf(nIndex,szName,nBytes);
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontAliasA(UINT nIndex,PSTR szName,UINT nBytes)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT,PSTR,UINT);
		pf = (UINT(WINAPI *)(UINT,PSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontAliasA");
		if (pf) return pf(nIndex,szName,nBytes);
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontAliasW(UINT nIndex,PWSTR szName,UINT nBytes)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT,PWSTR,UINT);
		pf = (UINT(WINAPI *)(UINT,PWSTR,UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontAliasW");
		if (pf) return pf(nIndex,szName,nBytes);
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontUUID(UINT nIndex,unsigned char* pUUID,UINT nBytes)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT,unsigned char*,UINT);
		pf = (UINT(WINAPI *)(UINT,unsigned char*,UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontUUID");
		if (pf) return pf(nIndex,pUUID,nBytes);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontDate(UINT nIndex)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT);
		pf = (UINT(WINAPI *)(UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontDate");
		if (pf) return pf(nIndex);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontVersion(UINT nIndex)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT);
		pf = (UINT(WINAPI *)(UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontVersion");
		if (pf) return pf(nIndex);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetFontFlags(UINT nIndex)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT);
		pf = (UINT(WINAPI *)(UINT))GetProcAddress(g_hDLL_Logox,"LogoxGetFontFlags");
		if (pf) return pf(nIndex);
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxLoadSettingsA(PCSTR szApplicationName)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(PCSTR);
		pf = (UINT(WINAPI *)(PCSTR))GetProcAddress(g_hDLL_Logox,"LogoxLoadSettingsA");
		if (pf) return pf(szApplicationName);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxLoadSettingsW(PCWSTR szApplicationName)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(PCWSTR);
		pf = (UINT(WINAPI *)(PCWSTR))GetProcAddress(g_hDLL_Logox,"LogoxLoadSettingsW");
		if (pf) return pf(szApplicationName);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSaveSettingsA(PCSTR szApplicationName)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(PCSTR);
		pf = (UINT(WINAPI *)(PCSTR))GetProcAddress(g_hDLL_Logox,"LogoxSaveSettingsA");
		if (pf) return pf(szApplicationName);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSaveSettingsW(PCWSTR szApplicationName)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(PCWSTR);
		pf = (UINT(WINAPI *)(PCWSTR))GetProcAddress(g_hDLL_Logox,"LogoxSaveSettingsW");
		if (pf) return pf(szApplicationName);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxResetLocal()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxResetLocal");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxResetGlobal()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxResetGlobal");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetAudioFormat(UINT nAudioFormat)
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)(UINT);
		pf = (UINT(WINAPI *)(UINT))GetProcAddress(g_hDLL_Logox,"LogoxSetAudioFormat");
		if (pf) return pf(nAudioFormat);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetAudioFormat()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetAudioFormat");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetLocalFont(UINT nFont)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(UINT);
		pf = (BOOL(WINAPI *)(UINT))GetProcAddress(g_hDLL_Logox,"LogoxSetLocalFont");
		if (pf) return pf(nFont);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetLocalFont()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetLocalFont");
		if (pf) return pf();
	}
	return 0xFFFFFFFF;
}


/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetGlobalFont(UINT nFont)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(UINT);
		pf = (BOOL(WINAPI *)(UINT))GetProcAddress(g_hDLL_Logox,"LogoxSetGlobalFont");
		if (pf) return pf(nFont);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
UINT WINAPI LogoxGetGlobalFont()
{
	if(LogoxLocateDLL())
	{
		UINT (WINAPI *pf)();
		pf = (UINT(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetGlobalFont");
		if (pf) return pf();
	}
	return 0xFFFFFFFF;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetLocalVolume(long nVolume)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetLocalVolume");
		if (pf) return pf(nVolume);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetLocalVolume()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetLocalVolume");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetGlobalVolume(long nVolume)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetGlobalVolume");
		if (pf) return pf(nVolume);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetGlobalVolume()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetGlobalVolume");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetLocalPitch(long nPitch)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetLocalPitch");
		if (pf) return pf(nPitch);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetLocalPitch()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetLocalPitch");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetGlobalPitch(long nPitch)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetGlobalPitch");
		if (pf) return pf(nPitch);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetGlobalPitch()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetGlobalPitch");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetLocalSpeed(long nSpeed)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetLocalSpeed");
		if (pf) return pf(nSpeed);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetLocalSpeed()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetLocalSpeed");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetGlobalSpeed(long nSpeed)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetGlobalSpeed");
		if (pf) return pf(nSpeed);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetGlobalSpeed()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetGlobalSpeed");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetLocalIntonation(long nIntonation)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetLocalIntonation");
		if (pf) return pf(nIntonation);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetLocalIntonation()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetLocalIntonation");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetGlobalIntonation(long nIntonation)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetGlobalIntonation");
		if (pf) return pf(nIntonation);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetGlobalIntonation()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetGlobalIntonation");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetLocalRoughness(long nRoughness)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetLocalRoughness");
		if (pf) return pf(nRoughness);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetLocalRoughness()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetLocalRoughness");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxSetGlobalRoughness(long nRoughness)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(long);
		pf = (BOOL(WINAPI *)(long))GetProcAddress(g_hDLL_Logox,"LogoxSetGlobalRoughness");
		if (pf) return pf(nRoughness);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
long WINAPI LogoxGetGlobalRoughness()
{
	if(LogoxLocateDLL())
	{
		long (WINAPI *pf)();
		pf = (long(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxGetGlobalRoughness");
		if (pf) return pf();
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyModeLocal()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxNotifyModeLocal");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyModeGlobal()
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)();
		pf = (BOOL(WINAPI *)())GetProcAddress(g_hDLL_Logox,"LogoxNotifyModeGlobal");
		if (pf) return pf();
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyAction(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyAction");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyMark(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyMark");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyChunk(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyChunk");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyParam(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyParam");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifySentence(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifySentence");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyWord(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyWord");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyMouth(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyMouth");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyViseme(HWND hWnd,UINT nMsg,HANDLE hEvent)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND,UINT,HANDLE);
		pf = (BOOL(WINAPI *)(HWND,UINT,HANDLE))GetProcAddress(g_hDLL_Logox,"LogoxNotifyViseme");
		if (pf) return pf(hWnd,nMsg,hEvent);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxNotifyBroadcast(HWND hWnd)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(HWND);
		pf = (BOOL(WINAPI *)(HWND))GetProcAddress(g_hDLL_Logox,"LogoxNotifyBroadcast");
		if (pf) return pf(hWnd);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxBroadcast(UINT nMsg,WPARAM wParam)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(UINT,WPARAM);
		pf = (BOOL(WINAPI *)(UINT,WPARAM))GetProcAddress(g_hDLL_Logox,"LogoxBroadcast");
		if (pf) return pf(nMsg,wParam);
	}
	return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
BOOL WINAPI LogoxCode(UINT nID,UINT nCode)
{
	if(LogoxLocateDLL())
	{
		BOOL (WINAPI *pf)(UINT,UINT);
		pf = (BOOL(WINAPI *)(UINT,UINT))GetProcAddress(g_hDLL_Logox,"LogoxCode");
		if (pf) return pf(nID,nCode);
	}
	return FALSE;
}

}